<!DOCTYPE html>
<html>
<head>
	<title>Tips and Tricks for using lawofone.info</title>
	<meta http-equiv="content-type" content="text/html; charset=utf-8">
	<meta name="keywords" content="law of one, infinite creator, logos, service to others, ra, seven densities, two paths, free will, unity">
	<link rel="shortcut icon" href="f1369028838favicon.ico" type="image/x-icon">
	<link rel="apple-touch-icon-precomposed" href="f-1869899766apple-touch-icon.png">
	<link rel="stylesheet" href="f-788052878styles.css" type="text/css">
	<meta name="description" content="How to get the most out of lawofone.info">
</head>
<body>
<h2>Tips and tricks for using <a href="_h_.html">lawofone.info</a></h2>
<div class="heading-list">
	<h3>Shorter URLs</h3>
<div id="right-column">

	<form accept-charset="UTF8" action="results.php" method="get" id="top-search">
<p style="margin: 0px;">
<input type="text" name="q" size="15" maxlength="250" value=""><br>
<button type="submit">Search</button>
</p>
<p style="margin-top: 4px; margin-bottom: 4px; text-align: center;">
		<a href="f731037089search.php">More options</a>
	</p>
</form>


</div>
	<p>To shorten links, you can use <a href="http://lo1.info/">lo1.info</a> or <a href="http://tloo.info/">tloo.info</a>.  You can link to sessions using <a href="f15121981">s/1</a> (or whatever session number), to queries using <a href="f1810469608lawofone">q/law of one</a>, and to categories using <a href="f778867638ArchetypicalMind">c/Archetypical Mind</a>.  So a short link to question 14 of session 10 would be <a href="http://lo1.info/s/10#14">lo1.info/s/10#14</a>.</p>

	<h3>Jump to specific question in a session</h3>
	<p>To link to a complete session with a specific question at the top, append “#” plus the question number to the URL.<br>
	   For example, to link to session 10 with question 14 at the top: <a href="f-118685385results.php">http://www.lawofone.info/results.php?s=10#14</a>.</p>

	<h3>Show only one question and answer</h3>
	<p>If you know exactly which question/answer you want, you can search for it using “session.question”.  For example, to show only session 10, question 14, search for “10.14”:
		<a href="f1521785784results.php">http://www.lawofone.info/results.php?q=10.14</a>.</p>

	<h3>Stemming</h3>
	<p>The search engine uses <a href="http://en.wikipedia.org/wiki/Stemming">stemming</a> to attempt to generate meaningful search results.  If you don’t want to use stemming, use “exact phrase” on the <a href="f60927671search.php">search page</a> (even if the phrase is only one word long).  For example, an <a href="f-235862020results.php">“any” search for beingness</a> will find “being,” also, but an <a href="f1458922292results.php">“exact phrase” search</a> will not.</p>

	<h3>Short words</h3>
	<p>In “any” searches, the search engine ignores short words such as “a,” “an,” “and,” and so on.  If you want to search for those words, use the “all” or “phrase” types of searches.</p>

	<h3>See more than 30 results at a time</h3>
	<p>By default, the site shows only 30 search results at a time.  Increase that on the <a href="f731037089search.php">search page</a> or by using the “l” <a href="#url-variables">URL variable</a>.</p>
	<h3>Sidebar</h3>
	<p>If your browser supports it, you can add a tool to search this site to your sidebar: <a href="javascript: addPanel()">Add to sidebar</a>.</p>

	<h3>Search Plugin</h3>
	<p>The <a href="https://addons.mozilla.org/en-US/firefox/addon/add-to-search-bar/">Add to Search Bar</a> plugin for Firefox
		lets you add to the list of search engines offered in the search box at the top right of the browser.</p>
	<p>Using it, you can add “The Law of One (Ra Material)” to the list of search engines Firefox offers:</p>
	<p><img src="f-1413920673search-plugin.jpg" width="243" height="226" alt="Search plugin"></p>

	<h3>Bookmark keyword</h3>
	<p>If your browser lets you add a keyword to bookmarks, you can jump straight to your desired search.  For example, in Firefox, you could follow these steps:</p>
		<ol>
			<li>Bookmark a lawofone.info search result.</li>
			<li>Edit the properties of the bookmark and change the location to http://www.lawofone.info/results.php?q=%s</li>
			<li>Add a keyword for the bookmark; for instance “l”</li>
		</ol>
	<p>Now you can search for, say, “honestation,” by typing “l honestation” in the URL field:</p>
	<p><img src="f1007165265bookmark-keyword.jpg" width="859" height="65" alt="Using a bookmark keyword"></p>
	<p>The <a href="https://addons.mozilla.org/en-US/firefox/addon/add-to-search-bar/">Add to Search Bar</a> plugin for Firefox
		mentioned above lets you assign a keyword in a single step.</p>
	<p>You could add another bookmark to quickly jump to a specific session.  Just use “s=%s” instead of “q=%s” in the location field.</p>

	<a name="url-variables"></a><h3>URL variables</h3>
	<p>Variables this site can pass in the URL string.</p>
	<p style="margin-bottom: 0px; font-weight: bold;">On any page:</p>
	<dl>
		<dt><b><i>sc</i></b>: show categories; (0 [no], 1 [yes]); defaults to 0.</dt>
		<dt><b><i>sn</i></b>: show notes (0 [no], 1 [yes]); defaults to 0.</dt>
		<dt><b><i>ss</i></b>: show session and question numbers (0 [no], 1 [yes]); defaults to 1.</dt>
		<dt><b><i>v</i></b>: version (e[dited], r[elistened], o[riginal]); defaults to e.</dt>
	</dl>

	<p style="margin-bottom: 0px; font-weight: bold;">On session pages:</p>
	<dl>
		<dt><b><i>s</i></b>: session (1-106).  Required.</dt>
		<dt><b><i>c</i></b>: category. To show only questions from a specific category in that session</dt>
		<dt><b><i>fp</i></b>: first published.  (0 → any [default], 1 → Book I, 2 → Book II, 3 → Book III, 4 → Book IV, 5 → Book V, 6 → Relistened Version)</dt>
		<dt><b><i>qi</i></b>: question id (0-75).  To show only a specific question/answer.</dt>
	</dl>

	<p style="margin-bottom: 0px; font-weight: bold;">On category pages:</p>
	<dl>
		<dt><b>c</b>: category.  Required.</dt>
		<dt><b><i>fp</i></b>: first published.  (See above.)</dt>
		<dt><b><i>l</i></b>: limit (how many Q &amp; As shown on a page); defaults to 30.</dt>
		<dt><b><i>sr</i></b>: start row (0-2630); defaults to 0.</dt>
		<dt><b><i>s</i></b>: session (1-106).  To show only questions/answers from a specific session in that category.</dt>
		<dt><b><i>su</i></b>: subcategory.  Must be in the category shown.</dt>
	</dl>

	<p style="margin-bottom: 0px; font-weight: bold;">On search result pages:</p>
	<dl>
		<dt><b><i>q</i></b>: query (search string).  Required.</dt>
		<dt><b><i>c</i></b>: category.  To search only a specific category</dt>
		<dt><b><i>fp</i></b>: first published.  (See above.)</dt>
		<dt><b><i>l</i></b>: limit (how many Q &amp; As shown on a page); defaults to 30.</dt>
		<dt><b><i>lh</i></b>: look here (a[nswers], q[uestions], aq [both]); defaults to both.</dt>
		<dt><b><i>o</i></b>: order by (r[elevance], s[ession]); defaults to relevance.</dt>
		<dt><b><i>qc</i></b>: query category (0 [no], 1 [yes]).  Search category and subcategory names as well as questions and answers.  E.g., show questions and answers from the “<a href="f-2055340073results.php">People</a>: <a href="f-1316957567results.php">Jesus</a>” subcategory if searching for “Jesus”.  <a href="f1352974279results.php">Search for Jesus with qc=1</a> (22 results).  <a href="f1352974278results.php">Search for Jesus with qc=0</a> (16 results).  Defaults to 0.  Preference is stored in a cookie.</dt>
		<dt><b><i>qo</i></b>: query omit.  Negative keywords.
		<dt><b><i>s</i></b>: session (1-106).  To search only a specific session.</dt>
		<dt><b><i>sr</i></b>: start row (0-2630); defaults to 0.</dt>
		<dt><b><i>st</i></b>: search type (any, all, phrase); defaults to any.</dt>
	</dl>

	<p style="margin-bottom: 0px; font-weight: bold;">Random question/answer pages:</p>
	<dl>
		<dt><b><i>random</i></b>: random (0 [no], 1 [yes]); defaults to 0.</dt>
	</dl>

	<p style="margin-bottom: 0px; font-weight: bold;">On difference pages:</p>
	<dl>
		<dt><b><i>dv</i></b>: difference version (o-e, r-e, llr-o, o-r, o-e-ao); defaults to o-e.</dt>
		<dt><b><i>s</i></b>: session (1-106).  Required.</dt>
	</dl>

	<h3>Cookie variables</h3>
	<p style="margin-bottom: 0px;">The site stores certain preferences in cookies.  If a variable is not set in the URL, it will use the value in the cookie, if set.  These are the cookie variables:</p>
	<dl>
		<dt><b><i>l</i></b>: limit</dt>
		<dt><b><i>o</i></b>: order by</dt>
		<dt><b><i>qc</i></b>: query category</dt>
		<dt><b><i>sc</i></b>: show categories</dt>
		<dt><b><i>sn</i></b>: show notes</dt>
		<dt><b><i>ss</i></b>: show session and question numbers</dt>
	</dl>

	<h3>Examples</h3>
	<p style="margin-bottom: 0px; font-weight: bold;">First published, session, category, version:</p>
	<dl>
		<dt>All questions and answers from the original version of <i>Book I</i>: <a href="f1598030551results.php">http://www.lawofone.info/results.php?fp=1&amp;v=o</a></dt>
		<dt>All questions and answers discovered in the relistening project; edited version: <a href="f1150692818results.php">http://www.lawofone.info/results.php?fp=6&amp;v=e</a></dt>
		<dt><i>Book V</i> questions in session 6: <a href="f2059022113results.php">http://www.lawofone.info/results.php?s=6&amp;fp=5</a></dt>
		<dt><i>Book III</i> questions having to do with the Archetypical Mind: <a href="f-363417943results.php">http://www.lawofone.info/results.php?c=Archetypical+Mind&amp;fp=3</a></dt>
	</dl>

	<p style="margin-bottom: 0px; font-weight: bold;">Session one showing question numbers, categories, and/or notes:</p>
	<dl>
		<dt>Show only question numbers: <a href="f270422243results.php">http://www.lawofone.info/results.php?s=1&amp;ss=1&amp;sc=0&amp;sn=0</a></dt>
		<dt>Show only categories: <a href="f918380609results.php">http://www.lawofone.info/results.php?s=1&amp;ss=0&amp;sc=1&amp;sn=0</a></dt>
		<dt>Show only notes: <a href="f1114894115results.php">http://www.lawofone.info/results.php?s=1&amp;ss=0&amp;sc=0&amp;sn=1</a></dt>
		<dt>Show all three: <a href="f73908739results.php">http://www.lawofone.info/results.php?s=1&amp;ss=1&amp;sc=1&amp;sn=1</a></dt>
		<dt>Show none: <a href="f-201396990results.php">http://www.lawofone.info/results.php?s=1&amp;sc=0&amp;ss=0&amp;sn=0</a></dt>
	</dl>

</div>
<p style="text-align: center; margin-top: 2em;">
	<a href="_h_.html">Home</a> ∙ 
	<a href="f731037089search.php">Search</a> ∙ 
	<a href="f-1390545771categories.php">Categories</a> ∙ 
	<a href="f-1574893994sessions.php">Sessions</a> ∙ 
	<a href="f-810092595synopsis.php">Synopsis</a> ∙ 
	<a href="f774683843favorite-quotes.php">Favorite&nbsp;Quotes</a> ∙ 
	<a href="f1285527712unusual-words.php">Unusual&nbsp;Words</a> ∙ 
	<a href="f-545413198relistening-report.php">Relistening Report</a> ∙ 
	<a href="f-2042705306tips-and-tricks.php">Tips and Tricks</a> ∙ 
	<a href="f1060319237results.php">Random&nbsp;Q&nbsp;&amp;&nbsp;A</a> ∙ 
	<a href="f2040867444links.php">Links</a> ∙ 
	<a href="f-920912309excerpts.php">Excerpts</a> ∙ 
	<a href="f-991132332versions.php">Versions</a> ∙ 
	<a href="f2063015009show-diff.php">Differences</a> ∙ 
	<a href="f653172817recent-updates.php">Recent&nbsp;Updates</a> ∙ 
	<a href="f1162575527current-goals.php">Current&nbsp;Goals</a> ∙ 
	<a href="f-1376487557recent-referrers.php">Recent Referrers</a> ∙ 
	<a href="f-504967805recent-searches.php">Recent Searches</a> ∙ 
	<a href="f-2075326040images">Images</a> ∙ 
	<a href="http://www.llresearch.org/">L/L Research</a> ∙ 
	<a href="http://www.bring4th.org/">Bring4th</a> ∙ 
	<a href="f-80480438support.php">Donate</a>
</p>
<p style="text-align: center;">The <i>Law of One</i> books are copyright &copy;1982, 1984, 1998 <a href="http://www.llresearch.org/">L/L Research</a>.  This site copyright &copy;2003&ndash;2013 Tobey Wheelock.</p>
<p style="text-align: center;">Questions? Comments? Email me: tw at law of one dot info.</p>
<script src="js/scripts.js" type="text/javascript"></script>
</body>
</html>
